/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.DropMode;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.TransferHandler;

public class DragTableExample {
    private JTable jTable;
    private int colCount = 11;
    private int rowCount = 10;

    public static void main(String ... stringArray) {
        DragTableExample dragTableExample = new DragTableExample();
        JFrame jFrame = new JFrame();
        jFrame.setDefaultCloseOperation(3);
        jFrame.add(new JScrollPane(dragTableExample.getJTable()));
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public DragTableExample() {
        JTextField jTextField = new JTextField("Drag This!");
        jTextField.setDragEnabled(true);
        this.jTable = new JTable(new MyDefTableModel((Vector)this.mkNames(), (Vector)this.mkData()));
        this.jTable.setDragEnabled(true);
        this.jTable.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                int n = DragTableExample.this.jTable.columnAtPoint(point);
                int n2 = DragTableExample.this.jTable.rowAtPoint(point);
                if (n == 0) {
                    DragTableExample.this.jTable.getSelectionModel().setSelectionInterval(n2, n2);
                    TransferHandler transferHandler = DragTableExample.this.jTable.getTransferHandler();
                    transferHandler.exportAsDrag(DragTableExample.this.jTable, mouseEvent, 2);
                }
            }
        });
        this.jTable.setDropMode(DropMode.INSERT_ROWS);
        this.jTable.setTransferHandler(new MyTransferHandler());
    }

    public JTable getJTable() {
        return this.jTable;
    }

    private Vector<String> mkNames() {
        Vector<String> vector = new Vector<String>(this.colCount + 1);
        vector.add("Col of drag");
        for (int i = 1; i < this.colCount; ++i) {
            vector.add("Col #" + String.valueOf(i));
        }
        return vector;
    }

    private Vector<Vector<Object>> mkData() {
        Vector<Vector<Object>> vector = new Vector<Vector<Object>>(this.rowCount);
        for (int i = 0; i < this.rowCount; ++i) {
            Vector<Object> vector2 = new Vector<Object>(this.colCount);
            for (int j = 0; j < this.colCount; ++j) {
                if (j == 0) {
                    vector2.add(new ImageIcon("images/drag_me_green.png"));
                    continue;
                }
                vector2.add("(" + String.valueOf(i) + "," + String.valueOf(j) + ")");
            }
            vector.add(vector2);
        }
        return vector;
    }

    private class MyTransferHandler
    extends TransferHandler {
        private MyTransferHandler() {
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport transferSupport) {
            return true;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport transferSupport) {
            JTable.DropLocation dropLocation = (JTable.DropLocation)transferSupport.getDropLocation();
            if (dropLocation.isInsertRow()) {
                MyDefTableModel myDefTableModel = (MyDefTableModel)DragTableExample.this.jTable.getModel();
                if (transferSupport.getTransferable().isDataFlavorSupported(JTableRowTransferable.DATA_ROW)) {
                    try {
                        Object[] objectArray = (Object[])transferSupport.getTransferable().getTransferData(JTableRowTransferable.DATA_ROW);
                        int n = (Integer)objectArray[0];
                        Object[] objectArray2 = ((Vector)objectArray[1]).toArray();
                        myDefTableModel.removeRow(n);
                        int n2 = dropLocation.getRow();
                        n2 = n2 >= DragTableExample.this.jTable.getRowCount() ? n2 - 1 : n2;
                        myDefTableModel.insertRow(n2, objectArray2);
                        return true;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
            return false;
        }

        @Override
        protected Transferable createTransferable(JComponent jComponent) {
            JTable jTable = (JTable)jComponent;
            int n = jTable.getSelectedRow();
            MyDefTableModel myDefTableModel = (MyDefTableModel)jTable.getModel();
            int n2 = myDefTableModel.getColumnCount();
            Vector<Object> vector = new Vector<Object>(n2);
            for (int i = 0; i < n2; ++i) {
                vector.add(myDefTableModel.getValueAt(n, i));
            }
            return new JTableRowTransferable(vector, n);
        }

        @Override
        public int getSourceActions(JComponent jComponent) {
            return 2;
        }
    }
}

