<?php

require 'config.inc.php';
require 'wampserver.lib.php';

////////////////////////////////////////////////////////////////////////
// call script with this cli :
// scriptName.php target switch
// target[...] : what do we need to switch
// switch[on|off] : switch on or off the target status
////////////////////////////////////////////////////////////////////////
function xdebug_extract_php_version($ini_wamp)
{
	global $ini_wamp;

	$version = phpversion();
	$match = array();
	if (preg_match('/Type: item; Caption: "([0-9]\.[0-9]\.[0-9])"; Action: multi; Actions:switchPhp[0-9]\.[0-9]\.[0-9]; Glyph: 13/i', $ini_wamp, $match))
	{
		$version = (isset($match[1]) ? $match[1] : $version);
	}
	return $version;
}

function xdebug_switch($type, $switch)
{
	global $ini_wamp, $ini_php, $xdebug_conf;

	if (empty($type))
	{
		die ('-');
	}

	//replace value in ini php
	if ($switch)
	{
		$ini_php = str_replace('#xdebug_' . $type . '=0', '#xdebug_' . $type . '=1', $ini_php);
		$find = ';';
		$new = '';
	}
	else
	{
		$ini_php = str_replace('#xdebug_' . $type . '=1', '#xdebug_' . $type . '=0', $ini_php);
		$find = '';
		$new = ';';
	}

	foreach($xdebug_conf[ $type ] as $_target)
	{
		$ini_php = str_replace($find . $_target, $new . $_target, $ini_php);
	}

	//changing wamp menu
	$menu_if_off = 'Type: item; Caption: "XDebug ' . $type . '"; Action: multi; Actions: php_xdebug_' . $type . '_on';
	$menu_if_on = 'Type: item; Caption: "XDebug ' . $type . '"; Glyph: 13; Action: multi; Actions: php_xdebug_' . $type . '_off';
	if ($switch)
	{
		$ini_wamp = str_replace($menu_if_off, $menu_if_on, $ini_wamp);	
	}
	else
	{
		$ini_wamp = str_replace($menu_if_on, $menu_if_off, $ini_wamp);	
	}
}

$xdebug_conf = array(
	'remote'	=> array(
		'xdebug.remote_enable',
		'xdebug.remote_host',
		'xdebug.remote_port',
		'xdebug.remote_handler'
	),
	'debug'	=> array(
		'zend_extension',
		'xdebug.default_enable',
		'xdebug.show_local_vars'
	),
	'profiler'	=> array(
		'xdebug.profiler_enable',
		'xdebug.profiler_output_dir',
		'xdebug.profiler_output_name'
	),
	'trace'	=> array(
		'xdebug.auto_trace',
		'xdebug.collect_return',
		'xdebug.trace_output_dir',
		'xdebug.trace_output_name'
	)
);
////////////////////////////////////////////////////////////////////////

//
// init
//
//switch on or off
$switch = (isset($_SERVER['argv'][2]) && $_SERVER['argv'][2] == 'on');
//what do we need to switch
$what = isset($_SERVER['argv'][1])?$_SERVER['argv'][1]:'';

$status = array_keys($xdebug_conf);
if (empty($what) || !in_array($what, $status))
{
	die('No service found');
}

//
// load files
//
//php ini file
$ini_php = @file_get_contents($c_phpConfFile) or die ("php.ini file not found");
$ini_wamp = @file_get_contents($wampserverIniFile) or die ("wampserver.ini file not found");

//
// extract status
//
$match = array();
$found = preg_match_all('/;#xdebug_(' . implode('|', $status) . ')=(1|0)/i', $ini_php, $match, PREG_PATTERN_ORDER);
if ($found == count($status))
{
	$match = array_combine($match[1], $match[2]);
}
else
{
	$match = array();
	foreach($status as $k)
	{
		$match[ $k ] = 0;
	}
}
$status = $match;
unset($match);

//
// switch the target
//
if (!$switch && $what == 'debug')
{
	//disactivation of xdebug, we need to disactivate all
	foreach($status as $k => $v)
	{
		if ($v)
		{
			xdebug_switch($k, false);
		}
	}
}
elseif ($switch && !$status['debug'] && $what != 'debug')
{
	//activation with debug off
	xdebug_switch('debug', true);
	xdebug_switch($what, true);
}
else
{
	xdebug_switch($what, $switch);
}

//
// save config
//
//ini php
$_ini_php = fopen($c_phpConfFile, 'w');
fwrite($_ini_php, $ini_php);
fclose($_ini_php);

//ini wamp
$_ini_wamp = fopen($wampserverIniFile, 'w');
fwrite($_ini_wamp, $ini_wamp);
fclose($_ini_wamp);

# EOF
