<?php

/**
 * @see Zend_View_Helper_Abstract
 */
require_once 'Zend/View/Helper/Abstract.php';

/**
 * @author Grummfy (http://grummfy.be)
 * @version 10-01-2010
 */
class Gru_View_Helper_OrderBy extends Zend_View_Helper_Abstract
{
	protected $_params = array();
	protected $_keys = array(
		'order'	=> 'order',
		'by'	=> 'by'
	);
	protected $_isArray = false;

	public function __construct()
	{
		$this->_getParams();
	}

	/**
	 * Choix des noms de clefs de variable pour l'url
	 * @param string $order
	 * @param string $by
	 */
	public function setKeys($order = 'order', $by = 'by')
	{
		$this->_keys['order'] = (empty($order)?'order':$order);
		$this->_keys['by'] = (empty($by)?'by':$by);
	}

	public function getKeys()
	{
		return $this->_keys;
	}

	public function orderBy()
	{
		return $this;
	}

	/**
	 * @param array $order [key:[label:string, by:asc|desc]] => <th><a href="order/asc/by/key">label</a></th>
	 * @param bool $reset true si on ne doit pas prendre en comtpe le reste des url
	 */
	public function th($order, $imgPath = null, $reset = true)
	{
		//TODO support des translates
		//TODO ajouter l'utilisation de décorateur
		//TODO si pas d'image ajouter caractère plein si actif, vide sinon : bas plein : &#9660; bas vide : &#9661;	haut vide : &#9651; haut plein &#9650;	
		//TODO ajouter un alt et un title 
		$str = '';
		foreach($order as $k => $v)
		{
			if (empty($v['by']))
			{
				$str .= '<th id="order_' . $k . '">' . $v['label'] . '</th>';
			}
			else
			{
				$str .= '<th id="order_' . $k . '"><a href="' . $this->orderBy()->url($k, $v['by'], $reset) . '">' .
				((empty($imgPath))?'':'<img src="' . $imgPath . $v['by'] . '.png" alt="' . $v['by'] . '">') . 
				$v['label'] . '</a></th>';
			} 
		}
		return $str;
	}

	/**
	 * Ordre de trie invers de l'actuel
	 * 
	 * @param string $field
	 * @param string $by
	 * @param bool $reset true si on ne doit pas prendre en comtpe le reste des url
	 * @param int $limit number of sort
	 * 
	 * @return string
	 */
	public function url($field, $by = 'asc', $reset = true, $limit = 2)
	{
		$by = ($by == 'desc')?'asc':'desc';
		$params = $this->_params;
		if ($reset)
		{
			$params[ $this->_keys['order'] ] = $field;
			$params[ $this->_keys['by'] ] = $by;
		}
		elseif(!$this->_isArray && empty($params[ $this->_keys['order'] ]))
		{
			$params[ $this->_keys['order'] ] = $field;
			$params[ $this->_keys['by'] ] = $by;
		}
		elseif(!$this->_isArray)
		{
			$params[ $this->_keys['order'] ] = array(
				$params[ $this->_keys['order'] ],
				$field
				);
			$params[ $this->_keys['by'] ] = array(
				$params[ $this->_keys['by'] ],
				$by
				);
		}
		elseif (in_array($field, $params[ $this->_keys['order'] ]))	
		{
			$k = array_search($field, $params[ $this->_keys['order'] ]);
			$params[ $this->_keys['by'] ][ $k ] = $by;
		}
		else
		{
			$params[ $this->_keys['order'] ][] = $field;
			$params[ $this->_keys['by'] ][] = $by;
		}

		//inversion & limit
		if (is_array($params[ $this->_keys['order'] ]))
		{
			krsort($params[ $this->_keys['order'] ]);
			krsort($params[ $this->_keys['by'] ]);
			if (!$reset)
			{
				while (count($params[ $this->_keys['order'] ]) > $limit)
				{
					array_pop($params[ $this->_keys['order'] ]);
					array_pop($params[ $this->_keys['by'] ]);
				}
			}
		}

		return $this->view->url($params);
	}

	protected function _getParams()
	{
		$request = Zend_Controller_Front::getInstance()->getRequest();
		//on enlève les post des params
		$this->_params = array_diff_assoc($request->getParams(), $request->getPost());

		if (!isset($this->_params[ $this->_keys['order'] ]))
		{
			$this->_params[ $this->_keys['order'] ] = '';
			$this->_params[ $this->_keys['by'] ] = '';
		}
		else
		{
			$this->_isArray = is_array($this->_params[ $this->_keys['order'] ]);
		}

		return $this->_params;
	}
}

# EOF
