<?php

/**
 * @author Grummfy (http://grummfy.be)
 * @version 10-01-2010
 */
class Gru_OrderBy
{
	protected $_order = array();
	protected $_locked = array();
	protected $_defaultNamespace = 'default';

	public function __construct($namespace = 'default')
	{
		$this->setDefaultNamespace($namespace);
	}

	/**
	 * Ajoute des clefs et leurs en-tête
	 * @param string $key
	 * @param string $label
	 * @param string|null $by
	 * @param string $namespace
	 */
	public function addKey($key, $label, $by = null, $namespace = '')
	{
		$namespace = $this->_getNamespace($namespace);

		if ($this->getLock($namespace))
		{
			return;
		}

		$order = $this->_getOrder($namespace);

		$order[ $key ]['label'] = $label;
		if (!empty($by))
		{
			$order[ $key ]['by'] = $by;
			$order[ $key ]['set'] = false;
		}

		$this->_setOrder($order, $namespace);
	}

	/**
	 * Renvoi les données : label et by d'une clef 
	 * @param string $key
	 * @param String $namespace
	 */
	public function getKey($key, $namespace = '')
	{
		$namespace = $this->_getNamespace($namespace);
		$order = $this->_getOrder($namespace);
		return $order[ $key ]; 
	}

	public function getKeys($namespace = '')
	{
		return $this->_getOrder($namespace);
	}

	public function getSqlKeys($namespace = '')
	{
		$ary = array();
		$order = $this->_getOrder($namespace);
		foreach ($order as $k => $v)
		{
			if (isset($v['by']) && $v['set'])
			{
				$ary[ ] = $k . ' ' . $v['by'];
			}
		}
		return $ary;
	}

	/**
	 * Supprime une clef
	 * @param string $key
	 * @param string $namespace
	 */
	public function removeKey($key, $namespace = '')
	{
		$namespace = $this->_getNamespace($namespace);

		if ($this->getLock($namespace))
		{
			return;
		}

		$order = $this->_getOrder($namespace);

		unset($order[ $key ]);

		$this->_setOrder($order, $namespace);
	}

	/**
	 * Verouille un namespace. Un namespace vérouillé peut encore être mixer ou récupéré  
	 * @param string $namespace
	 */
	public function lock($namespace = '')
	{
		$namespace = $this->_getNamespace($namespace);
		$this->_locked[ $namespace ] = true;
	}

	/**
	 * Renvoi le statut du verouillage
	 * @param string $namespace
	 */
	public function getLock($namespace = '')
	{
		return ($this->_locked[ $this->_getNamespace($namespace) ]);
	}

	/**
	 * Insert les paramètre récupéré via, par exemple, get http.
	 * 
	 * Les paramètres sont filtré(tag et slash), égalisé(des deux tableaux) et validé (uniquemnt si présent ici)
	 * 
	 * @param array|string $order
	 * @param array|string $by
	 * @param string $namespace
	 * 
	 * @return bool
	 */
	public function insertRequestParams($order, $by, $namespace = '')
	{
		if (empty($order) || empty($by))//si vide ou null
		{
			return false;
		}

		$namespace = $this->_getNamespace($namespace);

		//verrouillage
		$this->lock($namespace);

		//transformation en array
		if(!is_array($order)) 
		{
			$order = array($order);
		}
		
		if(!is_array($by)) 
		{
			$by = array($by);
		}

		//TODO utiliser Zend_Filter && add, remove Filter
		//filtrage
		foreach ($by as $k => $v)
		{
			$by[ $k ] = htmlspecialchars(addslashes(trim($v)));
			$by[ $k ] = (strcasecmp($by[ $k ], 'asc') == 0)?'asc':'desc';
		}

		foreach ($order as $k => $v)
		{
			$order[ $k ] = htmlspecialchars(addslashes(trim($v)));
		}

		//égalisage
		$count_order = count($order);
		$count_by = count($by);
		if ($count_order < $count_by)
		{
			//pop $by
			$diff = $count_by - $count_order;
			for ($i = $diff; $i > 0; $i--)
			{
				array_pop($by);
			}
		}
		elseif($count_order > $count_by)
		{
			array_pad($by, $count_order, 'asc');
		}

		//mixage
		$combine = array_combine($order, $by);

		//insertion
		$order = $this->_getOrder($namespace);
		foreach($combine as $k => $v)
		{
			if (isset($order[ $k ]) && isset($order[ $k ]['by']))
			{
				$order[ $k ]['by'] = $v;
				$order[ $k ]['set'] = true;
			}
		}

		$this->_setOrder($order, $namespace);

		return true;
	}

	/**
	 * Définin un namespace par défaut
	 * @param string $namespace
	 */
	public function setDefaultNamespace($namespace)
	{
		$namespace = trim($namespace);
		if (!empty($namespace))
			$this->_defaultNamespace = $namespace;
		else
			$this->_defaultNamespace = 'default';
	}

	protected function _getNamespace($namespace = '')
	{
		$namespace = trim($namespace);
		if (empty($namespace))
			$namespace = $this->_defaultNamespace;

		return $namespace;
	}

	protected function _getOrder($namespace = '')
	{
		$namespace = $this->_getNamespace($namespace);

		if (!isset($this->_order[ $namespace ]))
		{
			$this->_order[ $namespace ] = array();
			$this->_initLock($namespace);
		}
		return $this->_order[ $namespace ];
	}

	protected function _setOrder(array $value, $namespace = '')
	{
		$this->_order[ $this->_getNamespace($namespace) ] = $value;
	}

	protected function _initLock($namespace = '')
	{
		$this->_locked[ $this->_getNamespace($namespace) ] = false;
	}
}
